/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.humanoid;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import technology.rocketjump.undermount.assets.TextureAtlasRepository;
import technology.rocketjump.undermount.assets.entities.EntityAssetTypeDictionary;
import technology.rocketjump.undermount.assets.entities.humanoid.HumanoidEntityAssetDictionary;
import technology.rocketjump.undermount.assets.entities.humanoid.model.HumanoidEntityAsset;
import technology.rocketjump.undermount.assets.entities.model.SpriteDescriptor;
import technology.rocketjump.undermount.rendering.RenderMode;

public class HumanoidEntityAssetDictionaryProvider
implements Provider<HumanoidEntityAssetDictionary> {
    public static final float EPSILON = 1.0E-4f;
    private final EntityAssetTypeDictionary entityAssetTypeDictionary;
    private final TextureAtlasRepository textureAtlasRepository;

    @Inject
    public HumanoidEntityAssetDictionaryProvider(EntityAssetTypeDictionary entityAssetTypeDictionary, TextureAtlasRepository textureAtlasRepository) {
        this.entityAssetTypeDictionary = entityAssetTypeDictionary;
        this.textureAtlasRepository = textureAtlasRepository;
    }

    @Override
    public HumanoidEntityAssetDictionary get() {
        TextureAtlas diffuseTextureAtlas = this.textureAtlasRepository.get(TextureAtlasRepository.TextureAtlasType.DIFFUSE_ENTITIES);
        TextureAtlas normalTextureAtlas = this.textureAtlasRepository.get(TextureAtlasRepository.TextureAtlasType.NORMAL_ENTITIES);
        FileHandle entityDefinitionsFile = Gdx.files.internal("assets/definitions/entityAssets/humanoidEntityAssets.json");
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            List assetList = (List)objectMapper.readValue(entityDefinitionsFile.readString(), objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, HumanoidEntityAsset.class));
            for (HumanoidEntityAsset asset : assetList) {
                for (SpriteDescriptor spriteDescriptor : asset.getSpriteDescriptors().values()) {
                    HumanoidEntityAssetDictionaryProvider.addSprite(spriteDescriptor, diffuseTextureAtlas, RenderMode.DIFFUSE);
                    HumanoidEntityAssetDictionaryProvider.addSprite(spriteDescriptor, normalTextureAtlas, RenderMode.NORMALS);
                }
            }
            return new HumanoidEntityAssetDictionary(assetList, this.entityAssetTypeDictionary);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void addSprite(SpriteDescriptor spriteDescriptor, TextureAtlas textureAtlas, RenderMode renderMode) {
        Sprite sprite;
        String filename = spriteDescriptor.getFilename();
        if (filename.endsWith("_0.png")) {
            filename = filename.replace("_0.png", "");
        }
        if (filename.endsWith(".png")) {
            filename = filename.substring(0, filename.length() - 4);
        }
        if ((sprite = textureAtlas.createSprite(filename)) == null) {
            System.out.println("Warning: No sprite found for name " + filename + " in render mode " + renderMode.name());
            return;
        }
        sprite.setFlip(spriteDescriptor.isFlipX(), spriteDescriptor.isFlipY());
        if (spriteDescriptor.getScale() < 1.0E-4f) {
            spriteDescriptor.setScale(1.0f);
        }
        spriteDescriptor.setSprite(renderMode, sprite);
    }

    public static void addAnimatedSpriteArray(SpriteDescriptor spriteDescriptor, TextureAtlas textureAtlas, RenderMode renderMode) {
        String filename = spriteDescriptor.getFilename();
        if (filename.endsWith(".png")) {
            throw new RuntimeException("Animated sprite filename should not end with .png, found " + spriteDescriptor.getFilename());
        }
        Array<Sprite> spriteArray = textureAtlas.createSprites(filename);
        if (spriteArray == null) {
            System.out.println("Warning: No sprite found for name " + filename + " in render mode " + renderMode.name());
            return;
        }
        for (Sprite sprite : spriteArray) {
            sprite.setFlip(spriteDescriptor.isFlipX(), spriteDescriptor.isFlipY());
        }
        if (spriteDescriptor.getScale() < 1.0E-4f) {
            spriteDescriptor.setScale(1.0f);
        }
        spriteDescriptor.setAnimatedSprites(renderMode, spriteArray);
    }
}

